package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCoreNetworkChangeSetResponse(
    coreNetworkChanges: Optional[
      Iterable[zio.aws.networkmanager.model.CoreNetworkChange]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse = {
    import GetCoreNetworkChangeSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse
      .builder()
      .optionallyWith(
        coreNetworkChanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.coreNetworkChanges)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly =
    zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse
      .wrap(buildAwsValue())
}
object GetCoreNetworkChangeSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse =
      zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse(
        coreNetworkChanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def coreNetworkChanges: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getCoreNetworkChanges: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly
    ]] = AwsError.unwrapOptionField("coreNetworkChanges", coreNetworkChanges)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse
  ) extends zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly {
    override val coreNetworkChanges: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkChanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CoreNetworkChange.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse
  ): zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly =
    new Wrapper(impl)
}
