package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceState {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.DeviceState
}
object DeviceState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.DeviceState
  ): zio.aws.networkmanager.model.DeviceState = value match {
    case software.amazon.awssdk.services.networkmanager.model.DeviceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.DeviceState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.networkmanager.model.DeviceState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.DeviceState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.networkmanager.model.DeviceState.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.DeviceState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.DeviceState =
      software.amazon.awssdk.services.networkmanager.model.DeviceState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.networkmanager.model.DeviceState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.DeviceState =
      software.amazon.awssdk.services.networkmanager.model.DeviceState.PENDING
  }
  case object AVAILABLE extends zio.aws.networkmanager.model.DeviceState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.DeviceState =
      software.amazon.awssdk.services.networkmanager.model.DeviceState.AVAILABLE
  }
  case object DELETING extends zio.aws.networkmanager.model.DeviceState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.DeviceState =
      software.amazon.awssdk.services.networkmanager.model.DeviceState.DELETING
  }
  case object UPDATING extends zio.aws.networkmanager.model.DeviceState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.DeviceState =
      software.amazon.awssdk.services.networkmanager.model.DeviceState.UPDATING
  }
}
