package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{LinkId, GlobalNetworkId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteLinkRequest(
    globalNetworkId: GlobalNetworkId,
    linkId: LinkId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteLinkRequest = {
    import DeleteLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteLinkRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .linkId(LinkId.unwrap(linkId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.DeleteLinkRequest.ReadOnly =
    zio.aws.networkmanager.model.DeleteLinkRequest.wrap(buildAwsValue())
}
object DeleteLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteLinkRequest =
      zio.aws.networkmanager.model.DeleteLinkRequest(globalNetworkId, linkId)
    def globalNetworkId: GlobalNetworkId
    def linkId: LinkId
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getLinkId: ZIO[Any, Nothing, LinkId] = ZIO.succeed(linkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteLinkRequest
  ) extends zio.aws.networkmanager.model.DeleteLinkRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val linkId: LinkId =
      zio.aws.networkmanager.model.primitives.LinkId(impl.linkId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteLinkRequest
  ): zio.aws.networkmanager.model.DeleteLinkRequest.ReadOnly = new Wrapper(impl)
}
