package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ClientToken,
  ConstrainedString,
  IPAddress,
  AttachmentId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConnectPeerRequest(
    connectAttachmentId: AttachmentId,
    coreNetworkAddress: Optional[IPAddress] = Optional.Absent,
    peerAddress: IPAddress,
    bgpOptions: Optional[zio.aws.networkmanager.model.BgpOptions] =
      Optional.Absent,
    insideCidrBlocks: Iterable[ConstrainedString],
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateConnectPeerRequest = {
    import CreateConnectPeerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateConnectPeerRequest
      .builder()
      .connectAttachmentId(
        AttachmentId.unwrap(connectAttachmentId): java.lang.String
      )
      .optionallyWith(
        coreNetworkAddress.map(value =>
          IPAddress.unwrap(value): java.lang.String
        )
      )(_.coreNetworkAddress)
      .peerAddress(IPAddress.unwrap(peerAddress): java.lang.String)
      .optionallyWith(bgpOptions.map(value => value.buildAwsValue()))(
        _.bgpOptions
      )
      .insideCidrBlocks(insideCidrBlocks.map { item =>
        ConstrainedString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateConnectPeerRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateConnectPeerRequest.wrap(buildAwsValue())
}
object CreateConnectPeerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateConnectPeerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateConnectPeerRequest =
      zio.aws.networkmanager.model.CreateConnectPeerRequest(
        connectAttachmentId,
        coreNetworkAddress.map(value => value),
        peerAddress,
        bgpOptions.map(value => value.asEditable),
        insideCidrBlocks,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def connectAttachmentId: AttachmentId
    def coreNetworkAddress: Optional[IPAddress]
    def peerAddress: IPAddress
    def bgpOptions: Optional[zio.aws.networkmanager.model.BgpOptions.ReadOnly]
    def insideCidrBlocks: List[ConstrainedString]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def getConnectAttachmentId: ZIO[Any, Nothing, AttachmentId] =
      ZIO.succeed(connectAttachmentId)
    def getCoreNetworkAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("coreNetworkAddress", coreNetworkAddress)
    def getPeerAddress: ZIO[Any, Nothing, IPAddress] = ZIO.succeed(peerAddress)
    def getBgpOptions
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.BgpOptions.ReadOnly] =
      AwsError.unwrapOptionField("bgpOptions", bgpOptions)
    def getInsideCidrBlocks: ZIO[Any, Nothing, List[ConstrainedString]] =
      ZIO.succeed(insideCidrBlocks)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectPeerRequest
  ) extends zio.aws.networkmanager.model.CreateConnectPeerRequest.ReadOnly {
    override val connectAttachmentId: AttachmentId =
      zio.aws.networkmanager.model.primitives
        .AttachmentId(impl.connectAttachmentId())
    override val coreNetworkAddress: Optional[IPAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
    override val peerAddress: IPAddress =
      zio.aws.networkmanager.model.primitives.IPAddress(impl.peerAddress())
    override val bgpOptions
        : Optional[zio.aws.networkmanager.model.BgpOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bgpOptions())
        .map(value => zio.aws.networkmanager.model.BgpOptions.wrap(value))
    override val insideCidrBlocks: List[ConstrainedString] = impl
      .insideCidrBlocks()
      .asScala
      .map { item =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(item)
      }
      .toList
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.networkmanager.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectPeerRequest
  ): zio.aws.networkmanager.model.CreateConnectPeerRequest.ReadOnly =
    new Wrapper(impl)
}
