package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.AttachmentId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AcceptAttachmentRequest(attachmentId: AttachmentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentRequest = {
    import AcceptAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentRequest
      .builder()
      .attachmentId(AttachmentId.unwrap(attachmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.AcceptAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.AcceptAttachmentRequest.wrap(buildAwsValue())
}
object AcceptAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.AcceptAttachmentRequest =
      zio.aws.networkmanager.model.AcceptAttachmentRequest(attachmentId)
    def attachmentId: AttachmentId
    def getAttachmentId: ZIO[Any, Nothing, AttachmentId] =
      ZIO.succeed(attachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentRequest
  ) extends zio.aws.networkmanager.model.AcceptAttachmentRequest.ReadOnly {
    override val attachmentId: AttachmentId =
      zio.aws.networkmanager.model.primitives.AttachmentId(impl.attachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentRequest
  ): zio.aws.networkmanager.model.AcceptAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
