package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcOptions(ipv6Support: Optional[Boolean] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.VpcOptions = {
    import VpcOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.VpcOptions
      .builder()
      .optionallyWith(ipv6Support.map(value => value: java.lang.Boolean))(
        _.ipv6Support
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.VpcOptions.ReadOnly =
    zio.aws.networkmanager.model.VpcOptions.wrap(buildAwsValue())
}
object VpcOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.VpcOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.VpcOptions =
      zio.aws.networkmanager.model.VpcOptions(ipv6Support.map(value => value))
    def ipv6Support: Optional[Boolean]
    def getIpv6Support: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Support", ipv6Support)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.VpcOptions
  ) extends zio.aws.networkmanager.model.VpcOptions.ReadOnly {
    override val ipv6Support: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Support())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.VpcOptions
  ): zio.aws.networkmanager.model.VpcOptions.ReadOnly = new Wrapper(impl)
}
