package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  TransitGatewayRouteTableArn,
  PeeringId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TransitGatewayRouteTableAttachment(
    attachment: Optional[zio.aws.networkmanager.model.Attachment] =
      Optional.Absent,
    peeringId: Optional[PeeringId] = Optional.Absent,
    transitGatewayRouteTableArn: Optional[TransitGatewayRouteTableArn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.TransitGatewayRouteTableAttachment = {
    import TransitGatewayRouteTableAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.TransitGatewayRouteTableAttachment
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(
        peeringId.map(value => PeeringId.unwrap(value): java.lang.String)
      )(_.peeringId)
      .optionallyWith(
        transitGatewayRouteTableArn.map(value =>
          TransitGatewayRouteTableArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableArn)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment.ReadOnly =
    zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment
      .wrap(buildAwsValue())
}
object TransitGatewayRouteTableAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.TransitGatewayRouteTableAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment =
      zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment(
        attachment.map(value => value.asEditable),
        peeringId.map(value => value),
        transitGatewayRouteTableArn.map(value => value)
      )
    def attachment: Optional[zio.aws.networkmanager.model.Attachment.ReadOnly]
    def peeringId: Optional[PeeringId]
    def transitGatewayRouteTableArn: Optional[TransitGatewayRouteTableArn]
    def getAttachment
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Attachment.ReadOnly] =
      AwsError.unwrapOptionField("attachment", attachment)
    def getPeeringId: ZIO[Any, AwsError, PeeringId] =
      AwsError.unwrapOptionField("peeringId", peeringId)
    def getTransitGatewayRouteTableArn
        : ZIO[Any, AwsError, TransitGatewayRouteTableArn] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableArn",
        transitGatewayRouteTableArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.TransitGatewayRouteTableAttachment
  ) extends zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment.ReadOnly {
    override val attachment
        : Optional[zio.aws.networkmanager.model.Attachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachment())
        .map(value => zio.aws.networkmanager.model.Attachment.wrap(value))
    override val peeringId: Optional[PeeringId] = zio.aws.core.internal
      .optionalFromNullable(impl.peeringId())
      .map(value => zio.aws.networkmanager.model.primitives.PeeringId(value))
    override val transitGatewayRouteTableArn
        : Optional[TransitGatewayRouteTableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayRouteTableArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives
          .TransitGatewayRouteTableArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.TransitGatewayRouteTableAttachment
  ): zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment.ReadOnly =
    new Wrapper(impl)
}
