package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartRouteAnalysisResponse(
    routeAnalysis: Optional[zio.aws.networkmanager.model.RouteAnalysis] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisResponse = {
    import StartRouteAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisResponse
      .builder()
      .optionallyWith(routeAnalysis.map(value => value.buildAwsValue()))(
        _.routeAnalysis
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.StartRouteAnalysisResponse.ReadOnly =
    zio.aws.networkmanager.model.StartRouteAnalysisResponse
      .wrap(buildAwsValue())
}
object StartRouteAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.StartRouteAnalysisResponse =
      zio.aws.networkmanager.model.StartRouteAnalysisResponse(
        routeAnalysis.map(value => value.asEditable)
      )
    def routeAnalysis
        : Optional[zio.aws.networkmanager.model.RouteAnalysis.ReadOnly]
    def getRouteAnalysis: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysis.ReadOnly
    ] = AwsError.unwrapOptionField("routeAnalysis", routeAnalysis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisResponse
  ) extends zio.aws.networkmanager.model.StartRouteAnalysisResponse.ReadOnly {
    override val routeAnalysis
        : Optional[zio.aws.networkmanager.model.RouteAnalysis.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeAnalysis())
        .map(value => zio.aws.networkmanager.model.RouteAnalysis.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisResponse
  ): zio.aws.networkmanager.model.StartRouteAnalysisResponse.ReadOnly =
    new Wrapper(impl)
}
