package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait PeeringState {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.PeeringState
}
object PeeringState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.PeeringState
  ): zio.aws.networkmanager.model.PeeringState = value match {
    case software.amazon.awssdk.services.networkmanager.model.PeeringState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.PeeringState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.networkmanager.model.PeeringState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.networkmanager.model.PeeringState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.PeeringState.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.PeeringState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.PeeringState =
      software.amazon.awssdk.services.networkmanager.model.PeeringState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.networkmanager.model.PeeringState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.PeeringState =
      software.amazon.awssdk.services.networkmanager.model.PeeringState.CREATING
  }
  case object FAILED extends zio.aws.networkmanager.model.PeeringState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.PeeringState =
      software.amazon.awssdk.services.networkmanager.model.PeeringState.FAILED
  }
  case object AVAILABLE extends zio.aws.networkmanager.model.PeeringState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.PeeringState =
      software.amazon.awssdk.services.networkmanager.model.PeeringState.AVAILABLE
  }
  case object DELETING extends zio.aws.networkmanager.model.PeeringState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.PeeringState =
      software.amazon.awssdk.services.networkmanager.model.PeeringState.DELETING
  }
}
