package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{Integer, CoreNetworkId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCoreNetworkPolicyVersionRequest(
    coreNetworkId: CoreNetworkId,
    policyVersionId: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest = {
    import DeleteCoreNetworkPolicyVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .policyVersionId(policyVersionId: java.lang.Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest.ReadOnly =
    zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest
      .wrap(buildAwsValue())
}
object DeleteCoreNetworkPolicyVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest =
      zio.aws.networkmanager.model
        .DeleteCoreNetworkPolicyVersionRequest(coreNetworkId, policyVersionId)
    def coreNetworkId: CoreNetworkId
    def policyVersionId: Integer
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getPolicyVersionId: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(policyVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest
  ) extends zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val policyVersionId: Integer = impl.policyVersionId(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest
  ): zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest.ReadOnly =
    new Wrapper(impl)
}
