package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait GlobalNetworkState {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState
}
object GlobalNetworkState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState
  ): zio.aws.networkmanager.model.GlobalNetworkState = value match {
    case software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.GlobalNetworkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState =
      software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.networkmanager.model.GlobalNetworkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState =
      software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState.PENDING
  }
  case object AVAILABLE
      extends zio.aws.networkmanager.model.GlobalNetworkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState =
      software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState.AVAILABLE
  }
  case object DELETING extends zio.aws.networkmanager.model.GlobalNetworkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState =
      software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState.DELETING
  }
  case object UPDATING extends zio.aws.networkmanager.model.GlobalNetworkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState =
      software.amazon.awssdk.services.networkmanager.model.GlobalNetworkState.UPDATING
  }
}
