package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ConstrainedString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CoreNetworkChange(
    `type`: Optional[zio.aws.networkmanager.model.ChangeType] = Optional.Absent,
    action: Optional[zio.aws.networkmanager.model.ChangeAction] =
      Optional.Absent,
    identifier: Optional[ConstrainedString] = Optional.Absent,
    previousValues: Optional[
      zio.aws.networkmanager.model.CoreNetworkChangeValues
    ] = Optional.Absent,
    newValues: Optional[zio.aws.networkmanager.model.CoreNetworkChangeValues] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkChange = {
    import CoreNetworkChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkChange
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        identifier.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.identifier)
      .optionallyWith(previousValues.map(value => value.buildAwsValue()))(
        _.previousValues
      )
      .optionallyWith(newValues.map(value => value.buildAwsValue()))(
        _.newValues
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkChange.wrap(buildAwsValue())
}
object CoreNetworkChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkChange =
      zio.aws.networkmanager.model.CoreNetworkChange(
        `type`.map(value => value),
        action.map(value => value),
        identifier.map(value => value),
        previousValues.map(value => value.asEditable),
        newValues.map(value => value.asEditable)
      )
    def `type`: Optional[zio.aws.networkmanager.model.ChangeType]
    def action: Optional[zio.aws.networkmanager.model.ChangeAction]
    def identifier: Optional[ConstrainedString]
    def previousValues: Optional[
      zio.aws.networkmanager.model.CoreNetworkChangeValues.ReadOnly
    ]
    def newValues: Optional[
      zio.aws.networkmanager.model.CoreNetworkChangeValues.ReadOnly
    ]
    def getType: ZIO[Any, AwsError, zio.aws.networkmanager.model.ChangeType] =
      AwsError.unwrapOptionField("type", `type`)
    def getAction
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.ChangeAction] =
      AwsError.unwrapOptionField("action", action)
    def getIdentifier: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getPreviousValues: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkChangeValues.ReadOnly
    ] = AwsError.unwrapOptionField("previousValues", previousValues)
    def getNewValues: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkChangeValues.ReadOnly
    ] = AwsError.unwrapOptionField("newValues", newValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkChange
  ) extends zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly {
    override val `type`: Optional[zio.aws.networkmanager.model.ChangeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.networkmanager.model.ChangeType.wrap(value))
    override val action: Optional[zio.aws.networkmanager.model.ChangeAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.networkmanager.model.ChangeAction.wrap(value))
    override val identifier: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val previousValues: Optional[
      zio.aws.networkmanager.model.CoreNetworkChangeValues.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.previousValues())
      .map(value =>
        zio.aws.networkmanager.model.CoreNetworkChangeValues.wrap(value)
      )
    override val newValues: Optional[
      zio.aws.networkmanager.model.CoreNetworkChangeValues.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.newValues())
      .map(value =>
        zio.aws.networkmanager.model.CoreNetworkChangeValues.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkChange
  ): zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly = new Wrapper(impl)
}
