package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  SiteId,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSiteRequest(
    globalNetworkId: GlobalNetworkId,
    siteId: SiteId,
    description: Optional[ConstrainedString] = Optional.Absent,
    location: Optional[zio.aws.networkmanager.model.Location] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateSiteRequest = {
    import UpdateSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateSiteRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .siteId(SiteId.unwrap(siteId): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.UpdateSiteRequest.ReadOnly =
    zio.aws.networkmanager.model.UpdateSiteRequest.wrap(buildAwsValue())
}
object UpdateSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateSiteRequest =
      zio.aws.networkmanager.model.UpdateSiteRequest(
        globalNetworkId,
        siteId,
        description.map(value => value),
        location.map(value => value.asEditable)
      )
    def globalNetworkId: GlobalNetworkId
    def siteId: SiteId
    def description: Optional[ConstrainedString]
    def location: Optional[zio.aws.networkmanager.model.Location.ReadOnly]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getSiteId: ZIO[Any, Nothing, SiteId] = ZIO.succeed(siteId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateSiteRequest
  ) extends zio.aws.networkmanager.model.UpdateSiteRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val siteId: SiteId =
      zio.aws.networkmanager.model.primitives.SiteId(impl.siteId())
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val location
        : Optional[zio.aws.networkmanager.model.Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.networkmanager.model.Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateSiteRequest
  ): zio.aws.networkmanager.model.UpdateSiteRequest.ReadOnly = new Wrapper(impl)
}
