package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.AttachmentId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetVpcAttachmentRequest(attachmentId: AttachmentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetVpcAttachmentRequest = {
    import GetVpcAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetVpcAttachmentRequest
      .builder()
      .attachmentId(AttachmentId.unwrap(attachmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetVpcAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.GetVpcAttachmentRequest.wrap(buildAwsValue())
}
object GetVpcAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetVpcAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetVpcAttachmentRequest =
      zio.aws.networkmanager.model.GetVpcAttachmentRequest(attachmentId)
    def attachmentId: AttachmentId
    def getAttachmentId: ZIO[Any, Nothing, AttachmentId] =
      ZIO.succeed(attachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetVpcAttachmentRequest
  ) extends zio.aws.networkmanager.model.GetVpcAttachmentRequest.ReadOnly {
    override val attachmentId: AttachmentId =
      zio.aws.networkmanager.model.primitives.AttachmentId(impl.attachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetVpcAttachmentRequest
  ): zio.aws.networkmanager.model.GetVpcAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
