package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  FilterValue,
  FilterName,
  ConstrainedString,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetNetworkRoutesRequest(
    globalNetworkId: GlobalNetworkId,
    routeTableIdentifier: zio.aws.networkmanager.model.RouteTableIdentifier,
    exactCidrMatches: Optional[Iterable[ConstrainedString]] = Optional.Absent,
    longestPrefixMatches: Optional[Iterable[ConstrainedString]] =
      Optional.Absent,
    subnetOfMatches: Optional[Iterable[ConstrainedString]] = Optional.Absent,
    supernetOfMatches: Optional[Iterable[ConstrainedString]] = Optional.Absent,
    prefixListIds: Optional[Iterable[ConstrainedString]] = Optional.Absent,
    states: Optional[Iterable[zio.aws.networkmanager.model.RouteState]] =
      Optional.Absent,
    types: Optional[Iterable[zio.aws.networkmanager.model.RouteType]] =
      Optional.Absent,
    destinationFilters: Optional[Map[FilterName, Iterable[FilterValue]]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesRequest = {
    import GetNetworkRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .routeTableIdentifier(routeTableIdentifier.buildAwsValue())
      .optionallyWith(
        exactCidrMatches.map(value =>
          value.map { item =>
            ConstrainedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.exactCidrMatches)
      .optionallyWith(
        longestPrefixMatches.map(value =>
          value.map { item =>
            ConstrainedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.longestPrefixMatches)
      .optionallyWith(
        subnetOfMatches.map(value =>
          value.map { item =>
            ConstrainedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetOfMatches)
      .optionallyWith(
        supernetOfMatches.map(value =>
          value.map { item =>
            ConstrainedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supernetOfMatches)
      .optionallyWith(
        prefixListIds.map(value =>
          value.map { item =>
            ConstrainedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.prefixListIds)
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.typesWithStrings)
      .optionallyWith(
        destinationFilters.map(value =>
          value
            .map({ case (key, value) =>
              (FilterName.unwrap(key): java.lang.String) -> value.map { item =>
                FilterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.destinationFilters)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetNetworkRoutesRequest.ReadOnly =
    zio.aws.networkmanager.model.GetNetworkRoutesRequest.wrap(buildAwsValue())
}
object GetNetworkRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetNetworkRoutesRequest =
      zio.aws.networkmanager.model.GetNetworkRoutesRequest(
        globalNetworkId,
        routeTableIdentifier.asEditable,
        exactCidrMatches.map(value => value),
        longestPrefixMatches.map(value => value),
        subnetOfMatches.map(value => value),
        supernetOfMatches.map(value => value),
        prefixListIds.map(value => value),
        states.map(value => value),
        types.map(value => value),
        destinationFilters.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def routeTableIdentifier
        : zio.aws.networkmanager.model.RouteTableIdentifier.ReadOnly
    def exactCidrMatches: Optional[List[ConstrainedString]]
    def longestPrefixMatches: Optional[List[ConstrainedString]]
    def subnetOfMatches: Optional[List[ConstrainedString]]
    def supernetOfMatches: Optional[List[ConstrainedString]]
    def prefixListIds: Optional[List[ConstrainedString]]
    def states: Optional[List[zio.aws.networkmanager.model.RouteState]]
    def types: Optional[List[zio.aws.networkmanager.model.RouteType]]
    def destinationFilters: Optional[Map[FilterName, List[FilterValue]]]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getRouteTableIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.networkmanager.model.RouteTableIdentifier.ReadOnly
    ] = ZIO.succeed(routeTableIdentifier)
    def getExactCidrMatches: ZIO[Any, AwsError, List[ConstrainedString]] =
      AwsError.unwrapOptionField("exactCidrMatches", exactCidrMatches)
    def getLongestPrefixMatches: ZIO[Any, AwsError, List[ConstrainedString]] =
      AwsError.unwrapOptionField("longestPrefixMatches", longestPrefixMatches)
    def getSubnetOfMatches: ZIO[Any, AwsError, List[ConstrainedString]] =
      AwsError.unwrapOptionField("subnetOfMatches", subnetOfMatches)
    def getSupernetOfMatches: ZIO[Any, AwsError, List[ConstrainedString]] =
      AwsError.unwrapOptionField("supernetOfMatches", supernetOfMatches)
    def getPrefixListIds: ZIO[Any, AwsError, List[ConstrainedString]] =
      AwsError.unwrapOptionField("prefixListIds", prefixListIds)
    def getStates
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.RouteState]] =
      AwsError.unwrapOptionField("states", states)
    def getTypes
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.RouteType]] =
      AwsError.unwrapOptionField("types", types)
    def getDestinationFilters
        : ZIO[Any, AwsError, Map[FilterName, List[FilterValue]]] =
      AwsError.unwrapOptionField("destinationFilters", destinationFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesRequest
  ) extends zio.aws.networkmanager.model.GetNetworkRoutesRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val routeTableIdentifier
        : zio.aws.networkmanager.model.RouteTableIdentifier.ReadOnly =
      zio.aws.networkmanager.model.RouteTableIdentifier
        .wrap(impl.routeTableIdentifier())
    override val exactCidrMatches: Optional[List[ConstrainedString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exactCidrMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.ConstrainedString(item)
          }.toList
        )
    override val longestPrefixMatches: Optional[List[ConstrainedString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.longestPrefixMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.ConstrainedString(item)
          }.toList
        )
    override val subnetOfMatches: Optional[List[ConstrainedString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetOfMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.ConstrainedString(item)
          }.toList
        )
    override val supernetOfMatches: Optional[List[ConstrainedString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supernetOfMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.ConstrainedString(item)
          }.toList
        )
    override val prefixListIds: Optional[List[ConstrainedString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixListIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.ConstrainedString(item)
          }.toList
        )
    override val states
        : Optional[List[zio.aws.networkmanager.model.RouteState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.states())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.RouteState.wrap(item)
          }.toList
        )
    override val types: Optional[List[zio.aws.networkmanager.model.RouteType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.types())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.RouteType.wrap(item)
          }.toList
        )
    override val destinationFilters
        : Optional[Map[FilterName, List[FilterValue]]] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationFilters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.networkmanager.model.primitives
              .FilterName(key) -> value.asScala.map { item =>
              zio.aws.networkmanager.model.primitives.FilterValue(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesRequest
  ): zio.aws.networkmanager.model.GetNetworkRoutesRequest.ReadOnly =
    new Wrapper(impl)
}
