package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDeviceResponse(
    device: Optional[zio.aws.networkmanager.model.Device] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateDeviceResponse = {
    import UpdateDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateDeviceResponse
      .builder()
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.UpdateDeviceResponse.ReadOnly =
    zio.aws.networkmanager.model.UpdateDeviceResponse.wrap(buildAwsValue())
}
object UpdateDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateDeviceResponse =
      zio.aws.networkmanager.model
        .UpdateDeviceResponse(device.map(value => value.asEditable))
    def device: Optional[zio.aws.networkmanager.model.Device.ReadOnly]
    def getDevice
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateDeviceResponse
  ) extends zio.aws.networkmanager.model.UpdateDeviceResponse.ReadOnly {
    override val device
        : Optional[zio.aws.networkmanager.model.Device.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.device())
        .map(value => zio.aws.networkmanager.model.Device.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateDeviceResponse
  ): zio.aws.networkmanager.model.UpdateDeviceResponse.ReadOnly = new Wrapper(
    impl
  )
}
