package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.AttachmentId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConnectAttachment(
    attachment: Optional[zio.aws.networkmanager.model.Attachment] =
      Optional.Absent,
    transportAttachmentId: Optional[AttachmentId] = Optional.Absent,
    options: Optional[zio.aws.networkmanager.model.ConnectAttachmentOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ConnectAttachment = {
    import ConnectAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ConnectAttachment
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(
        transportAttachmentId.map(value =>
          AttachmentId.unwrap(value): java.lang.String
        )
      )(_.transportAttachmentId)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ConnectAttachment.ReadOnly =
    zio.aws.networkmanager.model.ConnectAttachment.wrap(buildAwsValue())
}
object ConnectAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ConnectAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ConnectAttachment =
      zio.aws.networkmanager.model.ConnectAttachment(
        attachment.map(value => value.asEditable),
        transportAttachmentId.map(value => value),
        options.map(value => value.asEditable)
      )
    def attachment: Optional[zio.aws.networkmanager.model.Attachment.ReadOnly]
    def transportAttachmentId: Optional[AttachmentId]
    def options: Optional[
      zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly
    ]
    def getAttachment
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Attachment.ReadOnly] =
      AwsError.unwrapOptionField("attachment", attachment)
    def getTransportAttachmentId: ZIO[Any, AwsError, AttachmentId] =
      AwsError.unwrapOptionField("transportAttachmentId", transportAttachmentId)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectAttachment
  ) extends zio.aws.networkmanager.model.ConnectAttachment.ReadOnly {
    override val attachment
        : Optional[zio.aws.networkmanager.model.Attachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachment())
        .map(value => zio.aws.networkmanager.model.Attachment.wrap(value))
    override val transportAttachmentId: Optional[AttachmentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transportAttachmentId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.AttachmentId(value)
        )
    override val options: Optional[
      zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        zio.aws.networkmanager.model.ConnectAttachmentOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectAttachment
  ): zio.aws.networkmanager.model.ConnectAttachment.ReadOnly = new Wrapper(impl)
}
