package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  LinkId,
  DeviceId,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LinkAssociation(
    globalNetworkId: Option[GlobalNetworkId] = None,
    deviceId: Option[DeviceId] = None,
    linkId: Option[LinkId] = None,
    linkAssociationState: Option[
      zio.aws.networkmanager.model.LinkAssociationState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.LinkAssociation = {
    import LinkAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.LinkAssociation
      .builder()
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .optionallyWith(linkAssociationState.map(value => value.unwrap))(
        _.linkAssociationState
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.LinkAssociation.ReadOnly =
    zio.aws.networkmanager.model.LinkAssociation.wrap(buildAwsValue())
}
object LinkAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.LinkAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.LinkAssociation =
      zio.aws.networkmanager.model.LinkAssociation(
        globalNetworkId.map(value => value),
        deviceId.map(value => value),
        linkId.map(value => value),
        linkAssociationState.map(value => value)
      )
    def globalNetworkId: Option[GlobalNetworkId]
    def deviceId: Option[DeviceId]
    def linkId: Option[LinkId]
    def linkAssociationState
        : Option[zio.aws.networkmanager.model.LinkAssociationState]
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
    def getLinkAssociationState: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.LinkAssociationState
    ] = AwsError.unwrapOptionField("linkAssociationState", linkAssociationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.LinkAssociation
  ) extends zio.aws.networkmanager.model.LinkAssociation.ReadOnly {
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val deviceId: Option[DeviceId] = scala
      .Option(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val linkId: Option[LinkId] = scala
      .Option(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val linkAssociationState
        : Option[zio.aws.networkmanager.model.LinkAssociationState] = scala
      .Option(impl.linkAssociationState())
      .map(value =>
        zio.aws.networkmanager.model.LinkAssociationState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.LinkAssociation
  ): zio.aws.networkmanager.model.LinkAssociation.ReadOnly = new Wrapper(impl)
}
