package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetNetworkResourceRelationshipsResponse(
    relationships: Option[Iterable[zio.aws.networkmanager.model.Relationship]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse = {
    import GetNetworkResourceRelationshipsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse
      .builder()
      .optionallyWith(
        relationships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationships)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse
      .wrap(buildAwsValue())
}
object GetNetworkResourceRelationshipsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse =
      zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse(
        relationships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def relationships
        : Option[List[zio.aws.networkmanager.model.Relationship.ReadOnly]]
    def nextToken: Option[NextToken]
    def getRelationships: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.Relationship.ReadOnly
    ]] = AwsError.unwrapOptionField("relationships", relationships)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse
  ) extends zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse.ReadOnly {
    override val relationships
        : Option[List[zio.aws.networkmanager.model.Relationship.ReadOnly]] =
      scala
        .Option(impl.relationships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Relationship.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse
  ): zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse.ReadOnly =
    new Wrapper(impl)
}
