package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLinkAssociationsResponse(
    linkAssociations: Option[
      Iterable[zio.aws.networkmanager.model.LinkAssociation]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse = {
    import GetLinkAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse
      .builder()
      .optionallyWith(
        linkAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.linkAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetLinkAssociationsResponse
      .wrap(buildAwsValue())
}
object GetLinkAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetLinkAssociationsResponse =
      zio.aws.networkmanager.model.GetLinkAssociationsResponse(
        linkAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def linkAssociations
        : Option[List[zio.aws.networkmanager.model.LinkAssociation.ReadOnly]]
    def nextToken: Option[NextToken]
    def getLinkAssociations: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.LinkAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("linkAssociations", linkAssociations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse
  ) extends zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly {
    override val linkAssociations
        : Option[List[zio.aws.networkmanager.model.LinkAssociation.ReadOnly]] =
      scala
        .Option(impl.linkAssociations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.LinkAssociation.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse
  ): zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
