package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DisassociateCustomerGatewayResponse(
    customerGatewayAssociation: Option[
      zio.aws.networkmanager.model.CustomerGatewayAssociation
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayResponse = {
    import DisassociateCustomerGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayResponse
      .builder()
      .optionallyWith(
        customerGatewayAssociation.map(value => value.buildAwsValue())
      )(_.customerGatewayAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse.ReadOnly =
    zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse
      .wrap(buildAwsValue())
}
object DisassociateCustomerGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse =
      zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse(
        customerGatewayAssociation.map(value => value.asEditable)
      )
    def customerGatewayAssociation: Option[
      zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
    ]
    def getCustomerGatewayAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customerGatewayAssociation",
      customerGatewayAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayResponse
  ) extends zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse.ReadOnly {
    override val customerGatewayAssociation: Option[
      zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
    ] = scala
      .Option(impl.customerGatewayAssociation())
      .map(value =>
        zio.aws.networkmanager.model.CustomerGatewayAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayResponse
  ): zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
