package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.GlobalNetworkId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartRouteAnalysisRequest(
    globalNetworkId: GlobalNetworkId,
    source: zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification,
    destination: zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification,
    includeReturnPath: Option[Boolean] = None,
    useMiddleboxes: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisRequest = {
    import StartRouteAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .source(source.buildAwsValue())
      .destination(destination.buildAwsValue())
      .optionallyWith(includeReturnPath.map(value => value: java.lang.Boolean))(
        _.includeReturnPath
      )
      .optionallyWith(useMiddleboxes.map(value => value: java.lang.Boolean))(
        _.useMiddleboxes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.StartRouteAnalysisRequest.ReadOnly =
    zio.aws.networkmanager.model.StartRouteAnalysisRequest.wrap(buildAwsValue())
}
object StartRouteAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.StartRouteAnalysisRequest =
      zio.aws.networkmanager.model.StartRouteAnalysisRequest(
        globalNetworkId,
        source.asEditable,
        destination.asEditable,
        includeReturnPath.map(value => value),
        useMiddleboxes.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def source
        : zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly
    def destination
        : zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly
    def includeReturnPath: Option[Boolean]
    def useMiddleboxes: Option[Boolean]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getSource: ZIO[
      Any,
      Nothing,
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly
    ] = ZIO.succeed(source)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly
    ] = ZIO.succeed(destination)
    def getIncludeReturnPath: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeReturnPath", includeReturnPath)
    def getUseMiddleboxes: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useMiddleboxes", useMiddleboxes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisRequest
  ) extends zio.aws.networkmanager.model.StartRouteAnalysisRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val source
        : zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly =
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
        .wrap(impl.source())
    override val destination
        : zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly =
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
        .wrap(impl.destination())
    override val includeReturnPath: Option[Boolean] =
      scala.Option(impl.includeReturnPath()).map(value => value: Boolean)
    override val useMiddleboxes: Option[Boolean] =
      scala.Option(impl.useMiddleboxes()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisRequest
  ): zio.aws.networkmanager.model.StartRouteAnalysisRequest.ReadOnly =
    new Wrapper(impl)
}
