package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  SiteArn,
  GlobalNetworkId,
  DateTime,
  SiteId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Site(
    siteId: Option[SiteId] = None,
    siteArn: Option[SiteArn] = None,
    globalNetworkId: Option[GlobalNetworkId] = None,
    description: Option[ConstrainedString] = None,
    location: Option[zio.aws.networkmanager.model.Location] = None,
    createdAt: Option[DateTime] = None,
    state: Option[zio.aws.networkmanager.model.SiteState] = None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Site = {
    import Site.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Site
      .builder()
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .optionallyWith(
        siteArn.map(value => SiteArn.unwrap(value): java.lang.String)
      )(_.siteArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Site.ReadOnly =
    zio.aws.networkmanager.model.Site.wrap(buildAwsValue())
}
object Site {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Site
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Site =
      zio.aws.networkmanager.model.Site(
        siteId.map(value => value),
        siteArn.map(value => value),
        globalNetworkId.map(value => value),
        description.map(value => value),
        location.map(value => value.asEditable),
        createdAt.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def siteId: Option[SiteId]
    def siteArn: Option[SiteArn]
    def globalNetworkId: Option[GlobalNetworkId]
    def description: Option[ConstrainedString]
    def location: Option[zio.aws.networkmanager.model.Location.ReadOnly]
    def createdAt: Option[DateTime]
    def state: Option[zio.aws.networkmanager.model.SiteState]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
    def getSiteArn: ZIO[Any, AwsError, SiteArn] =
      AwsError.unwrapOptionField("siteArn", siteArn)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getState: ZIO[Any, AwsError, zio.aws.networkmanager.model.SiteState] =
      AwsError.unwrapOptionField("state", state)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Site
  ) extends zio.aws.networkmanager.model.Site.ReadOnly {
    override val siteId: Option[SiteId] = scala
      .Option(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
    override val siteArn: Option[SiteArn] = scala
      .Option(impl.siteArn())
      .map(value => zio.aws.networkmanager.model.primitives.SiteArn(value))
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val location
        : Option[zio.aws.networkmanager.model.Location.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.networkmanager.model.Location.wrap(value))
    override val createdAt: Option[DateTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val state: Option[zio.aws.networkmanager.model.SiteState] = scala
      .Option(impl.state())
      .map(value => zio.aws.networkmanager.model.SiteState.wrap(value))
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Site
  ): zio.aws.networkmanager.model.Site.ReadOnly = new Wrapper(impl)
}
