package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RestoreCoreNetworkPolicyVersionResponse(
    coreNetworkPolicy: Option[zio.aws.networkmanager.model.CoreNetworkPolicy] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse = {
    import RestoreCoreNetworkPolicyVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse
      .builder()
      .optionallyWith(coreNetworkPolicy.map(value => value.buildAwsValue()))(
        _.coreNetworkPolicy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse.ReadOnly =
    zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse
      .wrap(buildAwsValue())
}
object RestoreCoreNetworkPolicyVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse =
      zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse(
        coreNetworkPolicy.map(value => value.asEditable)
      )
    def coreNetworkPolicy
        : Option[zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly]
    def getCoreNetworkPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("coreNetworkPolicy", coreNetworkPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse
  ) extends zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse.ReadOnly {
    override val coreNetworkPolicy
        : Option[zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly] =
      scala
        .Option(impl.coreNetworkPolicy())
        .map(value =>
          zio.aws.networkmanager.model.CoreNetworkPolicy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse
  ): zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse.ReadOnly =
    new Wrapper(impl)
}
