package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCoreNetworksResponse(
    coreNetworks: Option[
      Iterable[zio.aws.networkmanager.model.CoreNetworkSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse = {
    import ListCoreNetworksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse
      .builder()
      .optionallyWith(
        coreNetworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.coreNetworks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly =
    zio.aws.networkmanager.model.ListCoreNetworksResponse.wrap(buildAwsValue())
}
object ListCoreNetworksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListCoreNetworksResponse =
      zio.aws.networkmanager.model.ListCoreNetworksResponse(
        coreNetworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def coreNetworks
        : Option[List[zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getCoreNetworks: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("coreNetworks", coreNetworks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse
  ) extends zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly {
    override val coreNetworks: Option[
      List[zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly]
    ] = scala
      .Option(impl.coreNetworks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CoreNetworkSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse
  ): zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly =
    new Wrapper(impl)
}
