package zio.aws.networkmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCoreNetworkPolicyVersionsRequest(
    coreNetworkId: CoreNetworkId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest = {
    import ListCoreNetworkPolicyVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsRequest.ReadOnly =
    zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsRequest
      .wrap(buildAwsValue())
}
object ListCoreNetworkPolicyVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsRequest =
      zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsRequest(
        coreNetworkId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def coreNetworkId: CoreNetworkId
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest
  ) extends zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest
  ): zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
