package zio.aws.networkmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  NextToken,
  GlobalNetworkId,
  AWSAccountId,
  MaxResults,
  ExternalRegionCode,
  ResourceArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetNetworkResourceRelationshipsRequest(
    globalNetworkId: GlobalNetworkId,
    coreNetworkId: Option[CoreNetworkId] = None,
    registeredGatewayArn: Option[ResourceArn] = None,
    awsRegion: Option[ExternalRegionCode] = None,
    accountId: Option[AWSAccountId] = None,
    resourceType: Option[ConstrainedString] = None,
    resourceArn: Option[ResourceArn] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest = {
    import GetNetworkResourceRelationshipsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        registeredGatewayArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.registeredGatewayArn)
      .optionallyWith(
        awsRegion.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.awsRegion)
      .optionallyWith(
        accountId.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        resourceType.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetNetworkResourceRelationshipsRequest.ReadOnly =
    zio.aws.networkmanager.model.GetNetworkResourceRelationshipsRequest
      .wrap(buildAwsValue())
}
object GetNetworkResourceRelationshipsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetNetworkResourceRelationshipsRequest =
      zio.aws.networkmanager.model.GetNetworkResourceRelationshipsRequest(
        globalNetworkId,
        coreNetworkId.map(value => value),
        registeredGatewayArn.map(value => value),
        awsRegion.map(value => value),
        accountId.map(value => value),
        resourceType.map(value => value),
        resourceArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def coreNetworkId: Option[CoreNetworkId]
    def registeredGatewayArn: Option[ResourceArn]
    def awsRegion: Option[ExternalRegionCode]
    def accountId: Option[AWSAccountId]
    def resourceType: Option[ConstrainedString]
    def resourceArn: Option[ResourceArn]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getRegisteredGatewayArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("registeredGatewayArn", registeredGatewayArn)
    def getAwsRegion: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getResourceType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest
  ) extends zio.aws.networkmanager.model.GetNetworkResourceRelationshipsRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val coreNetworkId: Option[CoreNetworkId] = scala
      .Option(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val registeredGatewayArn: Option[ResourceArn] = scala
      .Option(impl.registeredGatewayArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val awsRegion: Option[ExternalRegionCode] = scala
      .Option(impl.awsRegion())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
      )
    override val accountId: Option[AWSAccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val resourceType: Option[ConstrainedString] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest
  ): zio.aws.networkmanager.model.GetNetworkResourceRelationshipsRequest.ReadOnly =
    new Wrapper(impl)
}
