package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  LinkId,
  DeviceId,
  GlobalNetworkId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociateLinkRequest(
    globalNetworkId: GlobalNetworkId,
    deviceId: DeviceId,
    linkId: LinkId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AssociateLinkRequest = {
    import AssociateLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AssociateLinkRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .linkId(LinkId.unwrap(linkId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.AssociateLinkRequest.ReadOnly =
    zio.aws.networkmanager.model.AssociateLinkRequest.wrap(buildAwsValue())
}
object AssociateLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AssociateLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.AssociateLinkRequest =
      zio.aws.networkmanager.model
        .AssociateLinkRequest(globalNetworkId, deviceId, linkId)
    def globalNetworkId: GlobalNetworkId
    def deviceId: DeviceId
    def linkId: LinkId
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
    def getLinkId: ZIO[Any, Nothing, LinkId] = ZIO.succeed(linkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateLinkRequest
  ) extends zio.aws.networkmanager.model.AssociateLinkRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val deviceId: DeviceId =
      zio.aws.networkmanager.model.primitives.DeviceId(impl.deviceId())
    override val linkId: LinkId =
      zio.aws.networkmanager.model.primitives.LinkId(impl.linkId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateLinkRequest
  ): zio.aws.networkmanager.model.AssociateLinkRequest.ReadOnly = new Wrapper(
    impl
  )
}
