package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  TransitGatewayArn,
  GlobalNetworkId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegisterTransitGatewayRequest(
    globalNetworkId: GlobalNetworkId,
    transitGatewayArn: TransitGatewayArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayRequest = {
    import RegisterTransitGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .transitGatewayArn(
        TransitGatewayArn.unwrap(transitGatewayArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RegisterTransitGatewayRequest.ReadOnly =
    zio.aws.networkmanager.model.RegisterTransitGatewayRequest
      .wrap(buildAwsValue())
}
object RegisterTransitGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RegisterTransitGatewayRequest =
      zio.aws.networkmanager.model
        .RegisterTransitGatewayRequest(globalNetworkId, transitGatewayArn)
    def globalNetworkId: GlobalNetworkId
    def transitGatewayArn: TransitGatewayArn
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getTransitGatewayArn: ZIO[Any, Nothing, TransitGatewayArn] =
      ZIO.succeed(transitGatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayRequest
  ) extends zio.aws.networkmanager.model.RegisterTransitGatewayRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val transitGatewayArn: TransitGatewayArn =
      zio.aws.networkmanager.model.primitives
        .TransitGatewayArn(impl.transitGatewayArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayRequest
  ): zio.aws.networkmanager.model.RegisterTransitGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
