package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ConstrainedString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Location(
    address: Option[ConstrainedString] = None,
    latitude: Option[ConstrainedString] = None,
    longitude: Option[ConstrainedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Location = {
    import Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Location
      .builder()
      .optionallyWith(
        address.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(
        latitude.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.latitude)
      .optionallyWith(
        longitude.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.longitude)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Location.ReadOnly =
    zio.aws.networkmanager.model.Location.wrap(buildAwsValue())
}
object Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Location =
      zio.aws.networkmanager.model.Location(
        address.map(value => value),
        latitude.map(value => value),
        longitude.map(value => value)
      )
    def address: Option[ConstrainedString]
    def latitude: Option[ConstrainedString]
    def longitude: Option[ConstrainedString]
    def getAddress: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("address", address)
    def getLatitude: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("latitude", latitude)
    def getLongitude: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("longitude", longitude)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Location
  ) extends zio.aws.networkmanager.model.Location.ReadOnly {
    override val address: Option[ConstrainedString] = scala
      .Option(impl.address())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val latitude: Option[ConstrainedString] = scala
      .Option(impl.latitude())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val longitude: Option[ConstrainedString] = scala
      .Option(impl.longitude())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Location
  ): zio.aws.networkmanager.model.Location.ReadOnly = new Wrapper(impl)
}
