package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCoreNetworkPolicyVersionsResponse(
    coreNetworkPolicyVersions: Option[
      Iterable[zio.aws.networkmanager.model.CoreNetworkPolicyVersion]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse = {
    import ListCoreNetworkPolicyVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse
      .builder()
      .optionallyWith(
        coreNetworkPolicyVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.coreNetworkPolicyVersions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse.ReadOnly =
    zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse
      .wrap(buildAwsValue())
}
object ListCoreNetworkPolicyVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse =
      zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse(
        coreNetworkPolicyVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def coreNetworkPolicyVersions: Option[
      List[zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getCoreNetworkPolicyVersions: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "coreNetworkPolicyVersions",
      coreNetworkPolicyVersions
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse
  ) extends zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse.ReadOnly {
    override val coreNetworkPolicyVersions: Option[
      List[zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly]
    ] = scala
      .Option(impl.coreNetworkPolicyVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CoreNetworkPolicyVersion.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse
  ): zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
