package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  GlobalNetworkId,
  LinkId,
  DateTime,
  SiteId,
  LinkArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Link(
    linkId: Option[LinkId] = None,
    linkArn: Option[LinkArn] = None,
    globalNetworkId: Option[GlobalNetworkId] = None,
    siteId: Option[SiteId] = None,
    description: Option[ConstrainedString] = None,
    `type`: Option[ConstrainedString] = None,
    bandwidth: Option[zio.aws.networkmanager.model.Bandwidth] = None,
    provider: Option[ConstrainedString] = None,
    createdAt: Option[DateTime] = None,
    state: Option[zio.aws.networkmanager.model.LinkState] = None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Link = {
    import Link.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Link
      .builder()
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .optionallyWith(
        linkArn.map(value => LinkArn.unwrap(value): java.lang.String)
      )(_.linkArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        `type`.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(bandwidth.map(value => value.buildAwsValue()))(
        _.bandwidth
      )
      .optionallyWith(
        provider.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.provider)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Link.ReadOnly =
    zio.aws.networkmanager.model.Link.wrap(buildAwsValue())
}
object Link {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Link
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Link =
      zio.aws.networkmanager.model.Link(
        linkId.map(value => value),
        linkArn.map(value => value),
        globalNetworkId.map(value => value),
        siteId.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        bandwidth.map(value => value.asEditable),
        provider.map(value => value),
        createdAt.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def linkId: Option[LinkId]
    def linkArn: Option[LinkArn]
    def globalNetworkId: Option[GlobalNetworkId]
    def siteId: Option[SiteId]
    def description: Option[ConstrainedString]
    def `type`: Option[ConstrainedString]
    def bandwidth: Option[zio.aws.networkmanager.model.Bandwidth.ReadOnly]
    def provider: Option[ConstrainedString]
    def createdAt: Option[DateTime]
    def state: Option[zio.aws.networkmanager.model.LinkState]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
    def getLinkArn: ZIO[Any, AwsError, LinkArn] =
      AwsError.unwrapOptionField("linkArn", linkArn)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("type", `type`)
    def getBandwidth
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Bandwidth.ReadOnly] =
      AwsError.unwrapOptionField("bandwidth", bandwidth)
    def getProvider: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("provider", provider)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getState: ZIO[Any, AwsError, zio.aws.networkmanager.model.LinkState] =
      AwsError.unwrapOptionField("state", state)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Link
  ) extends zio.aws.networkmanager.model.Link.ReadOnly {
    override val linkId: Option[LinkId] = scala
      .Option(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val linkArn: Option[LinkArn] = scala
      .Option(impl.linkArn())
      .map(value => zio.aws.networkmanager.model.primitives.LinkArn(value))
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val siteId: Option[SiteId] = scala
      .Option(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val `type`: Option[ConstrainedString] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val bandwidth
        : Option[zio.aws.networkmanager.model.Bandwidth.ReadOnly] = scala
      .Option(impl.bandwidth())
      .map(value => zio.aws.networkmanager.model.Bandwidth.wrap(value))
    override val provider: Option[ConstrainedString] = scala
      .Option(impl.provider())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val createdAt: Option[DateTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val state: Option[zio.aws.networkmanager.model.LinkState] = scala
      .Option(impl.state())
      .map(value => zio.aws.networkmanager.model.LinkState.wrap(value))
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Link
  ): zio.aws.networkmanager.model.Link.ReadOnly = new Wrapper(impl)
}
