package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetTransitGatewayConnectPeerAssociationsResponse(
    transitGatewayConnectPeerAssociations: Option[Iterable[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation
    ]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse = {
    import GetTransitGatewayConnectPeerAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
      .builder()
      .optionallyWith(
        transitGatewayConnectPeerAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayConnectPeerAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayConnectPeerAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse =
      zio.aws.networkmanager.model
        .GetTransitGatewayConnectPeerAssociationsResponse(
          transitGatewayConnectPeerAssociations.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def transitGatewayConnectPeerAssociations: Option[List[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
    ]]
    def nextToken: Option[NextToken]
    def getTransitGatewayConnectPeerAssociations: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayConnectPeerAssociations",
      transitGatewayConnectPeerAssociations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
  ) extends zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly {
    override val transitGatewayConnectPeerAssociations: Option[List[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
    ]] = scala
      .Option(impl.transitGatewayConnectPeerAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
  ): zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
