package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DisassociateLinkResponse(
    linkAssociation: Option[zio.aws.networkmanager.model.LinkAssociation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DisassociateLinkResponse = {
    import DisassociateLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DisassociateLinkResponse
      .builder()
      .optionallyWith(linkAssociation.map(value => value.buildAwsValue()))(
        _.linkAssociation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DisassociateLinkResponse.ReadOnly =
    zio.aws.networkmanager.model.DisassociateLinkResponse.wrap(buildAwsValue())
}
object DisassociateLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DisassociateLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DisassociateLinkResponse =
      zio.aws.networkmanager.model.DisassociateLinkResponse(
        linkAssociation.map(value => value.asEditable)
      )
    def linkAssociation
        : Option[zio.aws.networkmanager.model.LinkAssociation.ReadOnly]
    def getLinkAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.LinkAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("linkAssociation", linkAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateLinkResponse
  ) extends zio.aws.networkmanager.model.DisassociateLinkResponse.ReadOnly {
    override val linkAssociation
        : Option[zio.aws.networkmanager.model.LinkAssociation.ReadOnly] = scala
      .Option(impl.linkAssociation())
      .map(value => zio.aws.networkmanager.model.LinkAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateLinkResponse
  ): zio.aws.networkmanager.model.DisassociateLinkResponse.ReadOnly =
    new Wrapper(impl)
}
