package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteLinkResponse(
    link: Option[zio.aws.networkmanager.model.Link] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse = {
    import DeleteLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse
      .builder()
      .optionallyWith(link.map(value => value.buildAwsValue()))(_.link)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly =
    zio.aws.networkmanager.model.DeleteLinkResponse.wrap(buildAwsValue())
}
object DeleteLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteLinkResponse =
      zio.aws.networkmanager.model
        .DeleteLinkResponse(link.map(value => value.asEditable))
    def link: Option[zio.aws.networkmanager.model.Link.ReadOnly]
    def getLink
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Link.ReadOnly] =
      AwsError.unwrapOptionField("link", link)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse
  ) extends zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly {
    override val link: Option[zio.aws.networkmanager.model.Link.ReadOnly] =
      scala
        .Option(impl.link())
        .map(value => zio.aws.networkmanager.model.Link.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse
  ): zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly = new Wrapper(
    impl
  )
}
