package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateVpcAttachmentResponse(
    vpcAttachment: Option[zio.aws.networkmanager.model.VpcAttachment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentResponse = {
    import CreateVpcAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentResponse
      .builder()
      .optionallyWith(vpcAttachment.map(value => value.buildAwsValue()))(
        _.vpcAttachment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateVpcAttachmentResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateVpcAttachmentResponse
      .wrap(buildAwsValue())
}
object CreateVpcAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateVpcAttachmentResponse =
      zio.aws.networkmanager.model.CreateVpcAttachmentResponse(
        vpcAttachment.map(value => value.asEditable)
      )
    def vpcAttachment
        : Option[zio.aws.networkmanager.model.VpcAttachment.ReadOnly]
    def getVpcAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.VpcAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("vpcAttachment", vpcAttachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentResponse
  ) extends zio.aws.networkmanager.model.CreateVpcAttachmentResponse.ReadOnly {
    override val vpcAttachment
        : Option[zio.aws.networkmanager.model.VpcAttachment.ReadOnly] = scala
      .Option(impl.vpcAttachment())
      .map(value => zio.aws.networkmanager.model.VpcAttachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentResponse
  ): zio.aws.networkmanager.model.CreateVpcAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
