package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectPeerState {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.ConnectPeerState
}
object ConnectPeerState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.ConnectPeerState
  ): zio.aws.networkmanager.model.ConnectPeerState = value match {
    case software.amazon.awssdk.services.networkmanager.model.ConnectPeerState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectPeerState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectPeerState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectPeerState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectPeerState.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.ConnectPeerState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectPeerState =
      software.amazon.awssdk.services.networkmanager.model.ConnectPeerState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.networkmanager.model.ConnectPeerState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectPeerState =
      software.amazon.awssdk.services.networkmanager.model.ConnectPeerState.CREATING
  }
  case object FAILED extends zio.aws.networkmanager.model.ConnectPeerState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectPeerState =
      software.amazon.awssdk.services.networkmanager.model.ConnectPeerState.FAILED
  }
  case object AVAILABLE extends zio.aws.networkmanager.model.ConnectPeerState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectPeerState =
      software.amazon.awssdk.services.networkmanager.model.ConnectPeerState.AVAILABLE
  }
  case object DELETING extends zio.aws.networkmanager.model.ConnectPeerState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectPeerState =
      software.amazon.awssdk.services.networkmanager.model.ConnectPeerState.DELETING
  }
}
