package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AcceptAttachmentResponse(
    attachment: Option[zio.aws.networkmanager.model.Attachment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse = {
    import AcceptAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly =
    zio.aws.networkmanager.model.AcceptAttachmentResponse.wrap(buildAwsValue())
}
object AcceptAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.AcceptAttachmentResponse =
      zio.aws.networkmanager.model
        .AcceptAttachmentResponse(attachment.map(value => value.asEditable))
    def attachment: Option[zio.aws.networkmanager.model.Attachment.ReadOnly]
    def getAttachment
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Attachment.ReadOnly] =
      AwsError.unwrapOptionField("attachment", attachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse
  ) extends zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly {
    override val attachment
        : Option[zio.aws.networkmanager.model.Attachment.ReadOnly] = scala
      .Option(impl.attachment())
      .map(value => zio.aws.networkmanager.model.Attachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse
  ): zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
