package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  Integer,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCoreNetworkChangeSetRequest(
    coreNetworkId: CoreNetworkId,
    policyVersionId: Integer,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest = {
    import GetCoreNetworkChangeSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .policyVersionId(policyVersionId: java.lang.Integer)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetCoreNetworkChangeSetRequest.ReadOnly =
    zio.aws.networkmanager.model.GetCoreNetworkChangeSetRequest
      .wrap(buildAwsValue())
}
object GetCoreNetworkChangeSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetCoreNetworkChangeSetRequest =
      zio.aws.networkmanager.model.GetCoreNetworkChangeSetRequest(
        coreNetworkId,
        policyVersionId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def coreNetworkId: CoreNetworkId
    def policyVersionId: Integer
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getPolicyVersionId: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(policyVersionId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest
  ) extends zio.aws.networkmanager.model.GetCoreNetworkChangeSetRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val policyVersionId: Integer = impl.policyVersionId(): Integer
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest
  ): zio.aws.networkmanager.model.GetCoreNetworkChangeSetRequest.ReadOnly =
    new Wrapper(impl)
}
