package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  DeviceArn,
  GlobalNetworkId,
  DeviceId,
  DateTime,
  SiteId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Device(
    deviceId: Option[DeviceId] = None,
    deviceArn: Option[DeviceArn] = None,
    globalNetworkId: Option[GlobalNetworkId] = None,
    awsLocation: Option[zio.aws.networkmanager.model.AWSLocation] = None,
    description: Option[ConstrainedString] = None,
    `type`: Option[ConstrainedString] = None,
    vendor: Option[ConstrainedString] = None,
    model: Option[ConstrainedString] = None,
    serialNumber: Option[ConstrainedString] = None,
    location: Option[zio.aws.networkmanager.model.Location] = None,
    siteId: Option[SiteId] = None,
    createdAt: Option[DateTime] = None,
    state: Option[zio.aws.networkmanager.model.DeviceState] = None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Device = {
    import Device.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Device
      .builder()
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        deviceArn.map(value => DeviceArn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(awsLocation.map(value => value.buildAwsValue()))(
        _.awsLocation
      )
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        `type`.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        vendor.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.vendor)
      .optionallyWith(
        model.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.model)
      .optionallyWith(
        serialNumber.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Device.ReadOnly =
    zio.aws.networkmanager.model.Device.wrap(buildAwsValue())
}
object Device {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Device
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Device =
      zio.aws.networkmanager.model.Device(
        deviceId.map(value => value),
        deviceArn.map(value => value),
        globalNetworkId.map(value => value),
        awsLocation.map(value => value.asEditable),
        description.map(value => value),
        `type`.map(value => value),
        vendor.map(value => value),
        model.map(value => value),
        serialNumber.map(value => value),
        location.map(value => value.asEditable),
        siteId.map(value => value),
        createdAt.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deviceId: Option[DeviceId]
    def deviceArn: Option[DeviceArn]
    def globalNetworkId: Option[GlobalNetworkId]
    def awsLocation: Option[zio.aws.networkmanager.model.AWSLocation.ReadOnly]
    def description: Option[ConstrainedString]
    def `type`: Option[ConstrainedString]
    def vendor: Option[ConstrainedString]
    def model: Option[ConstrainedString]
    def serialNumber: Option[ConstrainedString]
    def location: Option[zio.aws.networkmanager.model.Location.ReadOnly]
    def siteId: Option[SiteId]
    def createdAt: Option[DateTime]
    def state: Option[zio.aws.networkmanager.model.DeviceState]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getDeviceArn: ZIO[Any, AwsError, DeviceArn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getAwsLocation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.AWSLocation.ReadOnly
    ] = AwsError.unwrapOptionField("awsLocation", awsLocation)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVendor: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getModel: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("model", model)
    def getSerialNumber: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getState: ZIO[Any, AwsError, zio.aws.networkmanager.model.DeviceState] =
      AwsError.unwrapOptionField("state", state)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Device
  ) extends zio.aws.networkmanager.model.Device.ReadOnly {
    override val deviceId: Option[DeviceId] = scala
      .Option(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val deviceArn: Option[DeviceArn] = scala
      .Option(impl.deviceArn())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceArn(value))
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val awsLocation
        : Option[zio.aws.networkmanager.model.AWSLocation.ReadOnly] = scala
      .Option(impl.awsLocation())
      .map(value => zio.aws.networkmanager.model.AWSLocation.wrap(value))
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val `type`: Option[ConstrainedString] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val vendor: Option[ConstrainedString] = scala
      .Option(impl.vendor())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val model: Option[ConstrainedString] = scala
      .Option(impl.model())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val serialNumber: Option[ConstrainedString] = scala
      .Option(impl.serialNumber())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val location
        : Option[zio.aws.networkmanager.model.Location.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.networkmanager.model.Location.wrap(value))
    override val siteId: Option[SiteId] = scala
      .Option(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
    override val createdAt: Option[DateTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val state: Option[zio.aws.networkmanager.model.DeviceState] = scala
      .Option(impl.state())
      .map(value => zio.aws.networkmanager.model.DeviceState.wrap(value))
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Device
  ): zio.aws.networkmanager.model.Device.ReadOnly = new Wrapper(impl)
}
