package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeGlobalNetworksResponse(
    globalNetworks: Option[
      Iterable[zio.aws.networkmanager.model.GlobalNetwork]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse = {
    import DescribeGlobalNetworksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse
      .builder()
      .optionallyWith(
        globalNetworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalNetworks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly =
    zio.aws.networkmanager.model.DescribeGlobalNetworksResponse
      .wrap(buildAwsValue())
}
object DescribeGlobalNetworksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DescribeGlobalNetworksResponse =
      zio.aws.networkmanager.model.DescribeGlobalNetworksResponse(
        globalNetworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def globalNetworks
        : Option[List[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly]]
    def nextToken: Option[NextToken]
    def getGlobalNetworks: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
    ]] = AwsError.unwrapOptionField("globalNetworks", globalNetworks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse
  ) extends zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly {
    override val globalNetworks
        : Option[List[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly]] =
      scala
        .Option(impl.globalNetworks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.GlobalNetwork.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse
  ): zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly =
    new Wrapper(impl)
}
