package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.SubnetArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VpcAttachment(
    attachment: Option[zio.aws.networkmanager.model.Attachment] = None,
    subnetArns: Option[Iterable[SubnetArn]] = None,
    options: Option[zio.aws.networkmanager.model.VpcOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.VpcAttachment = {
    import VpcAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.VpcAttachment
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(
        subnetArns.map(value =>
          value.map { item =>
            SubnetArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetArns)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.VpcAttachment.ReadOnly =
    zio.aws.networkmanager.model.VpcAttachment.wrap(buildAwsValue())
}
object VpcAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.VpcAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.VpcAttachment =
      zio.aws.networkmanager.model.VpcAttachment(
        attachment.map(value => value.asEditable),
        subnetArns.map(value => value),
        options.map(value => value.asEditable)
      )
    def attachment: Option[zio.aws.networkmanager.model.Attachment.ReadOnly]
    def subnetArns: Option[List[SubnetArn]]
    def options: Option[zio.aws.networkmanager.model.VpcOptions.ReadOnly]
    def getAttachment
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Attachment.ReadOnly] =
      AwsError.unwrapOptionField("attachment", attachment)
    def getSubnetArns: ZIO[Any, AwsError, List[SubnetArn]] =
      AwsError.unwrapOptionField("subnetArns", subnetArns)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.VpcOptions.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.VpcAttachment
  ) extends zio.aws.networkmanager.model.VpcAttachment.ReadOnly {
    override val attachment
        : Option[zio.aws.networkmanager.model.Attachment.ReadOnly] = scala
      .Option(impl.attachment())
      .map(value => zio.aws.networkmanager.model.Attachment.wrap(value))
    override val subnetArns: Option[List[SubnetArn]] = scala
      .Option(impl.subnetArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.SubnetArn(item)
        }.toList
      )
    override val options
        : Option[zio.aws.networkmanager.model.VpcOptions.ReadOnly] = scala
      .Option(impl.options())
      .map(value => zio.aws.networkmanager.model.VpcOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.VpcAttachment
  ): zio.aws.networkmanager.model.VpcAttachment.ReadOnly = new Wrapper(impl)
}
