package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  TransitGatewayArn,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TransitGatewayRegistration(
    globalNetworkId: Option[GlobalNetworkId] = None,
    transitGatewayArn: Option[TransitGatewayArn] = None,
    state: Option[
      zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistration = {
    import TransitGatewayRegistration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistration
      .builder()
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        transitGatewayArn.map(value =>
          TransitGatewayArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayArn)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly =
    zio.aws.networkmanager.model.TransitGatewayRegistration
      .wrap(buildAwsValue())
}
object TransitGatewayRegistration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.TransitGatewayRegistration =
      zio.aws.networkmanager.model.TransitGatewayRegistration(
        globalNetworkId.map(value => value),
        transitGatewayArn.map(value => value),
        state.map(value => value.asEditable)
      )
    def globalNetworkId: Option[GlobalNetworkId]
    def transitGatewayArn: Option[TransitGatewayArn]
    def state: Option[
      zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason.ReadOnly
    ]
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getTransitGatewayArn: ZIO[Any, AwsError, TransitGatewayArn] =
      AwsError.unwrapOptionField("transitGatewayArn", transitGatewayArn)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistration
  ) extends zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly {
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val transitGatewayArn: Option[TransitGatewayArn] = scala
      .Option(impl.transitGatewayArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives.TransitGatewayArn(value)
      )
    override val state: Option[
      zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason.ReadOnly
    ] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistration
  ): zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly =
    new Wrapper(impl)
}
