package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tagList: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.networkmanager.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListTagsForResourceResponse =
      zio.aws.networkmanager.model.ListTagsForResourceResponse(
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tagList: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceResponse
  ) extends zio.aws.networkmanager.model.ListTagsForResourceResponse.ReadOnly {
    override val tagList
        : Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] = scala
      .Option(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceResponse
  ): zio.aws.networkmanager.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
