package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListConnectPeersResponse(
    connectPeers: Option[
      Iterable[zio.aws.networkmanager.model.ConnectPeerSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse = {
    import ListConnectPeersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse
      .builder()
      .optionallyWith(
        connectPeers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectPeers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ListConnectPeersResponse.ReadOnly =
    zio.aws.networkmanager.model.ListConnectPeersResponse.wrap(buildAwsValue())
}
object ListConnectPeersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListConnectPeersResponse =
      zio.aws.networkmanager.model.ListConnectPeersResponse(
        connectPeers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connectPeers
        : Option[List[zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getConnectPeers: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("connectPeers", connectPeers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse
  ) extends zio.aws.networkmanager.model.ListConnectPeersResponse.ReadOnly {
    override val connectPeers: Option[
      List[zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly]
    ] = scala
      .Option(impl.connectPeers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.ConnectPeerSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse
  ): zio.aws.networkmanager.model.ListConnectPeersResponse.ReadOnly =
    new Wrapper(impl)
}
