package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetNetworkResourcesResponse(
    networkResources: Option[
      Iterable[zio.aws.networkmanager.model.NetworkResource]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse = {
    import GetNetworkResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse
      .builder()
      .optionallyWith(
        networkResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkResources)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetNetworkResourcesResponse.ReadOnly =
    zio.aws.networkmanager.model.GetNetworkResourcesResponse
      .wrap(buildAwsValue())
}
object GetNetworkResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetNetworkResourcesResponse =
      zio.aws.networkmanager.model.GetNetworkResourcesResponse(
        networkResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkResources
        : Option[List[zio.aws.networkmanager.model.NetworkResource.ReadOnly]]
    def nextToken: Option[NextToken]
    def getNetworkResources: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.NetworkResource.ReadOnly
    ]] = AwsError.unwrapOptionField("networkResources", networkResources)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse
  ) extends zio.aws.networkmanager.model.GetNetworkResourcesResponse.ReadOnly {
    override val networkResources
        : Option[List[zio.aws.networkmanager.model.NetworkResource.ReadOnly]] =
      scala
        .Option(impl.networkResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.NetworkResource.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesResponse
  ): zio.aws.networkmanager.model.GetNetworkResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
