package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateGlobalNetworkResponse(
    globalNetwork: Option[zio.aws.networkmanager.model.GlobalNetwork] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse = {
    import CreateGlobalNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse
      .builder()
      .optionallyWith(globalNetwork.map(value => value.buildAwsValue()))(
        _.globalNetwork
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateGlobalNetworkResponse
      .wrap(buildAwsValue())
}
object CreateGlobalNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateGlobalNetworkResponse =
      zio.aws.networkmanager.model.CreateGlobalNetworkResponse(
        globalNetwork.map(value => value.asEditable)
      )
    def globalNetwork
        : Option[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly]
    def getGlobalNetwork: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
    ] = AwsError.unwrapOptionField("globalNetwork", globalNetwork)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse
  ) extends zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly {
    override val globalNetwork
        : Option[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly] = scala
      .Option(impl.globalNetwork())
      .map(value => zio.aws.networkmanager.model.GlobalNetwork.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse
  ): zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
