package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectPeerAssociationState {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState
}
object ConnectPeerAssociationState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState
  ): zio.aws.networkmanager.model.ConnectPeerAssociationState = value match {
    case software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.ConnectPeerAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState =
      software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.networkmanager.model.ConnectPeerAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState =
      software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState.PENDING
  }
  case object AVAILABLE
      extends zio.aws.networkmanager.model.ConnectPeerAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState =
      software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState.AVAILABLE
  }
  case object DELETING
      extends zio.aws.networkmanager.model.ConnectPeerAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState =
      software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState.DELETING
  }
  case object DELETED
      extends zio.aws.networkmanager.model.ConnectPeerAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState =
      software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState.DELETED
  }
}
