package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AssociateConnectPeerResponse(
    connectPeerAssociation: Option[
      zio.aws.networkmanager.model.ConnectPeerAssociation
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AssociateConnectPeerResponse = {
    import AssociateConnectPeerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AssociateConnectPeerResponse
      .builder()
      .optionallyWith(
        connectPeerAssociation.map(value => value.buildAwsValue())
      )(_.connectPeerAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.AssociateConnectPeerResponse.ReadOnly =
    zio.aws.networkmanager.model.AssociateConnectPeerResponse
      .wrap(buildAwsValue())
}
object AssociateConnectPeerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AssociateConnectPeerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.AssociateConnectPeerResponse =
      zio.aws.networkmanager.model.AssociateConnectPeerResponse(
        connectPeerAssociation.map(value => value.asEditable)
      )
    def connectPeerAssociation
        : Option[zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly]
    def getConnectPeerAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "connectPeerAssociation",
      connectPeerAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateConnectPeerResponse
  ) extends zio.aws.networkmanager.model.AssociateConnectPeerResponse.ReadOnly {
    override val connectPeerAssociation
        : Option[zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly] =
      scala
        .Option(impl.connectPeerAssociation())
        .map(value =>
          zio.aws.networkmanager.model.ConnectPeerAssociation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateConnectPeerResponse
  ): zio.aws.networkmanager.model.AssociateConnectPeerResponse.ReadOnly =
    new Wrapper(impl)
}
