package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ConstrainedString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Relationship(
    from: Option[ConstrainedString] = None,
    to: Option[ConstrainedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Relationship = {
    import Relationship.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Relationship
      .builder()
      .optionallyWith(
        from.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.from)
      .optionallyWith(
        to.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.to)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Relationship.ReadOnly =
    zio.aws.networkmanager.model.Relationship.wrap(buildAwsValue())
}
object Relationship {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Relationship
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Relationship =
      zio.aws.networkmanager.model
        .Relationship(from.map(value => value), to.map(value => value))
    def from: Option[ConstrainedString]
    def to: Option[ConstrainedString]
    def getFrom: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("to", to)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Relationship
  ) extends zio.aws.networkmanager.model.Relationship.ReadOnly {
    override val from: Option[ConstrainedString] = scala
      .Option(impl.from())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val to: Option[ConstrainedString] = scala
      .Option(impl.to())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Relationship
  ): zio.aws.networkmanager.model.Relationship.ReadOnly = new Wrapper(impl)
}
